package agents;

import behaviours.*;
import jade.core.*;
import jade.domain.*;
import jade.domain.FIPAAgentManagement.*;

public class HumanAgent extends Agent {

	private static final long serialVersionUID = 1L;
	
	protected void setup() {
		//Register behaviour
		HumanCalmBehaviour calm = new HumanCalmBehaviour();
		addBehaviour(calm);
		
		//Register human
		DFAgentDescription agent_description = new DFAgentDescription();
		agent_description.setName(getAID());
		ServiceDescription agent_service = new ServiceDescription();
		agent_service.setName("Person");
		agent_service.setType("Person");
		agent_description.addServices(agent_service);
		try {
			DFService.register(this, agent_description);
		} catch (FIPAException e) {
			e.printStackTrace();
		}

	}
	
	protected void takeDown() {
		try {
			DFService.deregister(this);
		} catch (FIPAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println(this.getAID().getLocalName() + ": Nooooooo!");
		System.out.println("El agente " + this.getAID().getLocalName() + " ha muerto.");
	}
}
